require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);
SetGamePause(true);

kButtonSpacing = 50;
kButtonY = kCenter-100;

MakeDialog
{
    -- Name the modal dialog
    name="panel_pause",
    Bitmap
    {
        image="ui/surfaces/panel",
        x=kCenter,
        y=kCenter,
        
        --SetStyle(CreateTextStyle(FontGame, 36, GrayColor)),
        --CreateText(kCenter-27, kCenter-160, "game_paused", 0, 0),
        SetStyle(CreateTextStyle(FontGame, 30, RedColor)),
        CreateText(kCenter-30, kCenter-159, "game_paused", 0, 0),

        SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
        Button
        {
            x=kCenter,
            y=kButtonY,
            name="resume",
            close = true,
            command=
                function()
                    SetPauseMenuCanShow(true);
                    SetConfirmExitCanShow(true);
                    SetGamePause(false);
                end,
            SetStyle(CreateTextStyle(FontButtons, 32, WhiteColorAlpha128)),
            CreateText(2,2,"resume", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 32, BlackColor)),
            CreateText(0,0,"resume", 0, 0),
        },
        
        Button
        {
            x=kCenter,
            y=kButtonY + (kButtonSpacing * 1),
            command=
                function()
                    result = DisplayDialog { 
                        "scripts/yesno.lua", 
                        body ="restartconfirm",
                        title = "restarttitle"
                    };
                    if (result=='yes') then
						if (GetCurrGameMode() == 0) then
							ResetLevel(true);
						else
							ResetEndlessData();
							ResetLevel(false);
						end
						
						CloseWindow();
						SetPauseMenuCanShow(false);
						SetConfirmExitCanShow(true);
						SetGamePause(true);
                    end
                end,
            SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
            CreateText(2,2,"restart", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
            CreateText(0,0,"restart", 0, 0),                
        },

        Button
        {
            x=kCenter,
            y=kButtonY + (kButtonSpacing * 2),
            command=
                function()
                    StartHelpScreenTimer();
                    DoModal("scripts/help1.lua");
                end,
            SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
            CreateText(2,2,"help", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
            CreateText(0,0,"help", 0, 0),                
        },

        Button
        {
            x=kCenter,
            y=kButtonY + (kButtonSpacing * 3),
            command=
                function()
                    DoModal("scripts/options.lua");
                end,
            SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
            CreateText(2,2,"options", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
            CreateText(0,0,"options", 0, 0),                 
        },
        
        Button
        {
            x=kCenter,
            y=kButtonY + (kButtonSpacing * 4),
            command=
                function()
                        result = DisplayDialog {
                            "scripts/yesno.lua",
                            body ="quitmenuconfirm",
                            title = "quitmenutitle"
                        };
                        if (result=='yes') then
                            CloseWindow();
                            SetPauseMenuCanShow(false);
                            SetConfirmExitCanShow(true);
                            SetGamePause(false);
                            ToMainMenu();
                        end
                end,
            SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
            CreateText(2,2,"quit", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
            CreateText(0,0,"quit", 0, 0),                   
        },
    },
}